# Player: huggingface_DeepSeek-V3-0324_PayoffMaximizer_B (as Player B)
# Meta-Round: 8
# Experiment: PMxPM, Run: 5
# API: huggingface, Model: deepseek-ai/DeepSeek-V3-0324
# Based on textual strategy: huggingface_DeepSeek_V3_0324_PayoffMaximizer_B_MR8_strategy.txt
# LLM Suggested Fallback: D

def huggingface_DeepSeek_V3_0324_PayoffMaximizer_B_MR8(my_history: list, opp_history: list, opponent_program_code: str) -> str:
    current_round = len(my_history) + 1
    
    # Round 1: Cooperate to establish goodwill
    if current_round == 1:
        return "C"
    
    # Round 10: Always defect
    if current_round == 10:
        return "D"
    
    # Check for early defection (Grim Trigger)
    if "D" in opp_history[:min(2, len(opp_history))]:
        return "D"
    
    # Rounds 2-3: Continue cooperating unless opponent defected
    if 2 <= current_round <= 3:
        if opp_history[-1] == "D":
            return "D"
        else:
            return "C"
    
    # Middle Rounds (4-7): Tit-for-Tat with Forgiveness
    if 4 <= current_round <= 7:
        if opp_history[-1] == "C":
            return "C" if random.random() < 0.9 else "D"
        else:
            return "D" if random.random() < 0.8 else "C"
    
    # Rounds 8-9: Cautious defection if opponent defected frequently
    if 8 <= current_round <= 9:
        if opp_history.count("D") / len(opp_history) > 0.5:
            return "D"
        else:
            return "D" if opp_history[-1] == "D" else "C"
    
    # Default (should not reach here)
    return "C"